#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<math.h>
#include<alloc.h>
#include<string.h>
#include"pal.h"
/*.......................... Define Constants ..............................*/
#define DPI 0.01746
#define ON  1
#define OFF 0
/*....................... Define New data types ............................*/
typedef unsigned int  word;
typedef unsigned char byte;
typedef unsigned long dword;
typedef byte *pByte;
typedef int *pInt;
/*.......................... Define Structures .............................*/
struct Point2D{int x,y;};
struct Point3D{int x,y,z;};
struct Point2DR{float x,y;};
struct Point3DR{float x,y,z;};
/*.......................... Data declaration ..............................*/
byte *scr=(byte *)0xa0000000l,*tmp;
word ytab[200],ScrX=160,ScrY=100;
int pl[200][4],chkflg,MapX,MapY;
pByte *Map;
pInt *Zbuf;
/*..........................................................................*/
/*.......................... Global Functions ..............................*/
/*..........................................................................*/
/*..................... Modernisated Sin and Cos operations ................*/
double inline sin(int alp){return sin(alp*DPI);}
double inline cos(int alp){return cos(alp*DPI);}
/*........................ Wait vertical Retrace ...........................*/
void WaitRetrace()
{
asm{push ax;push dx;mov dx,0x03da}
WaitNVSL:
asm{in al,dx;and al,0x08;jnz WaitNVSL}
WaitVSL:
asm{in al,dx;and al,0x08;jz WaitVSL;pop dx;pop ax;}
}
/*....................... Load Map for Texturing ...........................*/
int LoadMap(char *name)
{
int i,j;
FILE *io;
if(!(io=fopen(name,"rb"))) return 0;
fseek(io,18l,SEEK_SET);MapX=fgetc(io)+256*fgetc(io);
fseek(io,22l,SEEK_SET);MapY=fgetc(io)+256*fgetc(io);
if(!(Map=new pByte[MapY])) {fclose(io);return 0;}
fseek(io,1078l,SEEK_SET);
for(i=0;i<MapY;i++)
{if(!(Map[i]=new byte[MapX])){for(j=0;j<i;j++) delete [] Map[j];delete Map;return 0;}
 fread(Map[i],MapX,1,io);
}
fclose(io);
return 1;
}
/*............................. Unload Map .................................*/
void UnLoadMap()
{for(int i=0;i<MapY;i++) delete [] Map[i];delete [] Map;}
/*........................ Turn ON or OFF Video ............................*/
int Video(int mode)
{
int i,j;
switch(mode)
{
case 1: for(i=0;i<200;i++)ytab[i]=i*320;
	if(!(tmp=(byte *)farmalloc(64000L))){printf("Error allocating memory for screen buffer (64 Kb)\n");return 0;}
	memset(tmp,0,(size_t)64000L);
	if(!(Zbuf=new pInt[200])){printf("Error allocating memory for Z buffer (200 bytes)\n");return 0;}	for(i=0;i<200;i++) {
			    if(!(Zbuf[i]=new int[320])){printf("Error allocating memory Z buffer (%d bytes - %d line)\n",i*320,i);return 0;}
			    for(j=0;j<320;j++) Zbuf[i][j]=-32000;
			   }
	asm{mov ax,0x13;int 0x10}
	break;
case 0: farfree(tmp);
	for(i=0;i<200;i++) delete [] Zbuf[i];
	delete [] Zbuf;
	asm{mov ax,0x3;int 0x10}
	break;
}
return 1;
}
/*......................... Cliping video pages ............................*/
void Clip(int mode)
{
memcpy(scr,tmp,(size_t)64000l);
if(!mode) memset(tmp,0,(size_t)64000l);
for(int i=0;i<200;i++)
    for(int j=0;j<320;j++)
	Zbuf[i][j]=-32000;
}
/*......................... Put normal 2D pixel ............................*/
void inline pixel(word x,word y,byte color)
{if(x<320&&y<200) tmp[ytab[y]+x]=color;}
/*.................... Put normal 2D pixel with Z buffer ...................*/
void inline pixelZ(int x,int y,int z,byte color)
{if(x<320&&y<200&&x>=0&&y>=0&&Zbuf[y][x]<z)
   {tmp[ytab[y]+x]=color;Zbuf[y][x]=z;}
}
/*......................... Get normal 2D pixel ............................*/
byte getpixel(word x,word y,byte *from)
{if(x<320&&y<200)return from[ytab[y]+x];else return 0;}
/*.................... Integer Line draw function ..........................*/
void line(Point2D p1,Point2D p2,byte color)
{
int x=p1.x<<6,y=p1.y<<6,dx=(p2.x-p1.x),dy=(p2.y-p1.y),len;
if(abs(dx)>abs(dy))len=abs(dx);else len=abs(dy);
dx<<=6;dy<<=6;
if(len){dx/=len;dy/=len;}else{dx=0;dy=0;}
for(int i=0;i<len;i++,x+=dx,y+=dy) pixel(x>>6,y>>6,color);
}
/*............... Integer Line draw with Z buffer ..........................*/
void lineZ(Point2D p1,int z1,Point2D p2,int z2,byte color)
{
int x=p1.x<<6,y=p1.y<<6,z=z1<<6;
int dx=(p2.x-p1.x),dy=(p2.y-p1.y),len;
int dz=((z2-z1)<<6);
if(abs(dx)>abs(dy))len=abs(dx);else len=abs(dy);
dx<<=6;dy<<=6;dz<<6;
if(len){dx/=len;dy/=len;dz/=len;}else{dx=0;dy=0;dz=0;}
for(int i=0;i<len;i++,x+=dx,y+=dy,z+=dz) pixelZ(x>>6,y>>6,z>>6,color);
}
/*..........................................................................*/
/*......................... 3D Drawing functions ...........................*/
/*..........................................................................*/
/*............. Integer 3D Pixel to 2D Pixel Transformations ...............*/
Point2D inline to2d(int x,int y,int z)
{
Point2D Ret;
Ret.x=ScrX+x*(700/(float)(700-z));
Ret.y=ScrY+y*(700/(float)(700-z));
return Ret;
}
Point2D inline to2d(Point3D p)
{
Point2D Ret;
Ret.x=ScrX+p.x*(700/(float)(700-p.z));
Ret.y=ScrY+p.y*(700/(float)(700-p.z));
return Ret;
}
/*...................... Integer 3D Pixel ..................................*/
void Pixel3D(Point3D p,byte color)
{Point2D A=to2d(p);pixel(A.x,A.y,color);}
/*............... Integer 3D Pixel with Z buffering ........................*/
void Pixel3DZ(Point3D p,byte color)
{Point2D A=to2d(p);pixelZ(A.x,A.y,p.z,color);}
/*.................. Integer Line 3D draw function .........................*/
void Line3D(Point3D p1,Point3D p2,byte color)
{line(to2d(p1),to2d(p2),color);}
/*.............. Integer Line 3D draw with Z bufer .........................*/
void Line3DZ(Point3D p1,Point3D p2,byte color)
{lineZ(to2d(p1),p1.z,to2d(p2),p2.z,color);}
/*.................... Integer Rotate 3D point .............................*/
Point3D RotatePoint(Point3D in,int Xang,int Yang,int Zang)
{
Point3D Ret;
float sX=sin(Xang),sY=sin(Yang),sZ=sin(Zang);
float cX=cos(Xang),cY=cos(Yang),cZ=cos(Zang);
Ret.z=  -sY*in.x+           sX*cY*in.y+           cX*cY*in.z;
Ret.x=cY*cZ*in.x+(sX*sY*cZ-cX*sZ)*in.y+(cX*sY*cZ+sX*sZ)*in.z;
Ret.y=cY*sZ*in.x+(sX*sY*sZ+cX*cZ)*in.y+(cX*sY*sZ-sX*cZ)*in.z;
return Ret;
}
/*...................... Scan PolySide .....................................*/
void PolySide(Point2D p1,int z1,Point2D p2,int z2)
{
Point2D t;
int dx,dz,x,z,xp,i=p1.y;
if(p2.y==p1.y)
 {
  if(i>=0&&i<200){pl[i][0]=pl[i][1]=p1.x;pl[i][2]=z1;pl[i][3]=z2;}
  return;
 }
if(p2.y<p1.y) {t=p1;p1=p2;p2=t;x=z1;z1=z2;z2=x;}
dx=((p2.x-p1.x)<<6)/abs(p2.y-p1.y);
dz=((z2-z1)<<6)/abs(p2.y-p1.y);
for(i=p1.y,x=p1.x<<6,z=z1<<6;i<=p2.y;i++,x+=dx,z+=dz)
 if(i>=0&&i<200)
   {
    xp=x>>6;
    if(xp<pl[i][0]) {pl[i][0]=xp;pl[i][2]=z>>6;}
    if(xp>pl[i][1]) {pl[i][1]=xp;pl[i][3]=z>>6;}
   }
}
/*.......................... Fill Polygone .................................*/
void Hline(int x1,int x2,int y,int z1,int z2,byte color)
{
int dz,z,i;
if(x2<x1) return;
if(x2!=x1) dz=((z2-z1)<<6)/(x2-x1);
else       dz=0;
for(i=x1,z=z1<<6;i<x2;i++,z+=dz) pixelZ(i,y,z>>6,color);
}
/*...................... 4 Side Polygone Drawer ............................*/
void Polygone(Point3D i1,Point3D i2,Point3D i3,Point3D i4,byte color)
{
for(int i=0;i<200;i++){pl[i][0]=320;pl[i][1]=0;pl[i][2]=0;pl[i][3]=0;}
Point2D A=to2d(i1),
B=to2d(i2);PolySide(A,i1.z,B,i2.z);
A=to2d(i3);PolySide(B,i2.z,A,i3.z);
B=to2d(i4);PolySide(A,i3.z,B,i4.z);
A=to2d(i1);PolySide(B,i4.z,A,i1.z);
for(int i=0;i<200;i++) Hline(pl[i][0],pl[i][1],i,pl[i][2],pl[i][3],color);
}
/*.................. 3 Side Polygone (Triangel) Drawer .....................*/
void Triangel(Point3D i1,Point3D i2,Point3D i3,byte color)
{
for(int i=0;i<200;i++){pl[i][0]=400;pl[i][1]=0;pl[i][2]=0;pl[i][3]=0;}
Point2D A=to2d(i1),
B=to2d(i2);PolySide(A,i1.z,B,i2.z);
A=to2d(i3);PolySide(B,i2.z,A,i3.z);
B=to2d(i1);PolySide(A,i3.z,B,i1.z);
for(int i=0;i<200;i++) Hline(pl[i][0],pl[i][1],i,pl[i][2],pl[i][3],color);
}
/*..........................................................................*/
/*.......................... Texturing Functions ...........................*/
/*..........................................................................*/
/*........................... Line Stepper final ...........................*/
Point3D LineStep(Point2D P1,int z1,Point2D P2,int z2,int size,int n)
{
Point3D Ret;
int x=P1.x<<6,y=P1.y<<6,z=z1<<6;
int dx=((P2.x-P1.x)<<6)/size;
int dy=((P2.y-P1.y)<<6)/size;
int dz=((z2-z1)<<6)/size;
for(int i=0;i<n;i++,x+=dx,y+=dy,z+=dz);
Ret.x=x>>6;
Ret.y=y>>6;
Ret.z=z>>6;
return Ret;
}
/*............................. Texutered Line .............................*/
void TextureLine(Point3D P1,Point3D P2,int size,int n)
{
int x=P1.x<<6,y=P1.y<<6,z=P1.z<<6;
int dx=((P2.x-P1.x)<<6)/size;
int dy=((P2.y-P1.y)<<6)/size;
int dz=((P2.z-P1.z)<<6)/size;
for(int t=0;t<size;t++,x+=dx,y+=dy,z+=dz)
	pixelZ(x>>6,y>>6,z>>6,Map[t][n]);
}
/*....................... Textured Polygone Drawer .........................*/
void TPolygone(Point3D i1,Point3D i2,Point3D i3,Point3D i4,int MapX,int MapY)
{
Point2D A1=to2d(i1),A2=to2d(i2),A3=to2d(i3),A4=to2d(i4);
for(int i=0;i<MapX;i++)
    TextureLine(LineStep(A1,i1.z,A4,i4.z,MapX,i),
		LineStep(A2,i2.z,A3,i3.z,MapX,i),
		MapY,i);
}
/*..........................................................................*/
/*......................... 3D Object Class ................................*/
/*..........................................................................*/
class Object3D{
      Point3D *points,*outpnt,Place;
      int XaO,YaO,ZaO,XaS,YaS,ZaS;
      int P,L,G,Type;
      Point2D *lines;
      int *draw;
  private:
      void MoveC(int x,int y,int z);
  public:
      ~Object3D();
      Object3D(char *name);
      void Show(int x,int y,byte color,int mode);
      void Rotate(int Ox,int Oy,int Oz,int Sx,int Sy,int Sz);
      void Move(int x,int y,int z);
};
/*................ Class constryctor - Creat new object ....................*/
Object3D::Object3D(char *name)
{
int i,j;
FILE *in;
char sign[8];
if(!(in=fopen(name,"rb"))){printf("ERROR: Can't open file %s.\n",name);exit(0);}
fscanf(in,"%s",sign);
if(strcmp(sign,"PFCo3D4")){printf("ERROR: file %s is not 3D object.\n",name);exit(0);}
fscanf(in,"%d%d%d",&XaO,&YaO,&ZaO);
fscanf(in,"%d%d%d",&XaS,&YaS,&ZaS);
fscanf(in,"%d%d%d",&Place.x,&Place.y,&Place.z);
fscanf(in,"%d",&P);
if(!(points=new Point3D[P])){printf("ERROR: Can't allocate memory (%d 3d points).\n",P);exit(0);}
if(!(outpnt=new Point3D[P])){printf("ERROR: Can't allocate memory (%d 3d rotated points).\n",P);exit(0);}
for(i=0;i<P;i++){fscanf(in,"%d%d%d",&points[i].x,&points[i].y,&points[i].z);outpnt[i]=points[i];}
fscanf(in,"%d",&L);
if(!(lines=new Point2D[L])){printf("ERROR: Can't allocate memory (%d lines).\n",L);exit(0);}
for(i=0;i<L;i++) fscanf(in,"%d%d",&lines[i].x,&lines[i].y);
fscanf(in,"%d%d",&G,&Type);
if(G)
{
if(!(draw=new int[G])){printf("ERROR: Can't allocate memory (%d polygone info).\n",G);exit(0);}
for(i=0;i<G;i++){fscanf(in,"%d",&j);if(j)draw[i]=1;else draw[i]=0;}
}
fclose(in);
Rotate(XaO,YaO,ZaO,XaS,YaS,YaS);
}
/*................. Class Destructor - Delete Object  ......................*/
Object3D::~Object3D()
{
delete [] points;
delete [] outpnt;
delete [] lines;
if(G)
delete [] draw;
}
/*......................... Show 3D Object .................................*/
void Object3D::Show(int x,int y,byte color,int mode)
{
int i,j;
ScrX=x;ScrY=y;
switch(mode)
{
case 0: for(i=0;i<P;i++) Pixel3DZ(outpnt[i],color);break;
case 1: for(i=0;i<L;i++) Line3DZ(outpnt[lines[i].x],outpnt[lines[i].y],color);break;
case 2: for(j=0,i=0;j<G;j++,i+=Type)
	   {
	    if(draw[j])
	       switch(Type)
		 {
		 case 3: Triangel(outpnt[i],outpnt[i+1],outpnt[i+2],color-j);break;
		 case 4: Polygone(outpnt[i],outpnt[i+1],outpnt[i+2],outpnt[i+3],color-j);break;
		 }
	   }
	break;
case 3: for(j=0,i=0;j<G;j++,i+=Type)
	   {
	    if(draw[j])
	       switch(Type)
		 {
		 case 4: TPolygone(outpnt[i],outpnt[i+1],outpnt[i+2],outpnt[i+3],MapX,MapY);break;
		 }
	   }
	break;
}
}
/*..................... Move 3D object in 3D Coordinates ...................*/
void Object3D::MoveC(int x,int y,int z)
{
for(int i=0;i<P;i++)
  {
  outpnt[i].x+=x;
  outpnt[i].y+=y;
  outpnt[i].z+=z;
  }
}
/*..................... Move 3D object on Scene ............................*/
void Object3D::Move(int x,int y,int z)
{Place.x=x;Place.y=y;Place.z=z;}
/*............. Rotate 3D Object in X,Y or Z direction .....................*/
void Object3D::Rotate(int Ox,int Oy,int Oz,int Sx,int Sy,int Sz)
{
int i;
XaO+=Ox;YaO+=Oy;ZaO+=Oz;
XaS+=Sx;YaS+=Sy;ZaS+=Sz;
for(i=0;i<P;i++) outpnt[i]=RotatePoint(points[i],XaO,YaO,ZaO);
MoveC(Place.x,Place.y,Place.z);
for(i=0;i<P;i++) outpnt[i]=RotatePoint(outpnt[i],XaS,YaS,ZaS);
}
/*..........................................................................*/
/*..................... Main function for probe ............................*/
/*..........................................................................*/
void main()
{
Object3D P1("Data\\sp1.o3d"),P2("Data\\sp2.o3d"),P3("Data\\sp3.o3d");
Object3D SUN("Data\\sun.o3d"),B("Data\\pcube.o3d");
if(!LoadMap("Data\\1.bmp")) return;
if(!Video(ON)) return;
randomize();
PalGenerator(-1); // -1 for change pallete
SetPal();
while(!kbhit())
{
if(!chkflg){PalGenerator(-1);chkflg=1;}
else        ChangePal();
B.Show  (160,100,250,3);
P1.Show (160,100,150,2);
P2.Show (160,100,100,2);
P3.Show (160,100, 80,2);
SUN.Show(160,100,200,2);
P1.Rotate ( 0, 10, 0,0,3,0);
P2.Rotate (-1, 10, 1,0,4,0);
P3.Rotate ( 1,-10, 1,0,2,0);
SUN.Rotate( 1, 10, 1,0,1,0);
B.Rotate  (-1, 10,-1,0,1,0);
Blur(tmp);
Clip(ON);
}
UnLoadMap();
Video(OFF);
}